unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  TrazamedLib_TLB;

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  trazamedObj: ITrazaMed;
  med: medicamentosDTO;
begin

    // Realiza el registro de una transaccin de medicamento.
    // El usuario (laboratorio/droguera/operador logstico/farmacia) informa el evento ocurrido para cada uno de los medicamentos.

    trazamedObj := CoTrazaMed.Create;
    med := ComedicamentosDTO.Create;

    trazamedObj.modo_produccion := False;
    trazamedObj.LogTransaction('Request.xml', 'Response.xml'); //Deja un log de cada transaccion en los archivos.

    trazamedObj.usuario := 'pruebasws';
    trazamedObj.password := 'pruebasws';

    med.f_evento := '24/04/2012';
    med.h_evento := '04:24';
    med.gln_origen := '9999999999918';
    med.gln_destino := 'glnws';
    med.n_remito := 'R000100000001';
    med.n_factura := 'F000100000001';
    med.vencimiento := '30/12/2011';
    med.gtin := 'GTIN2';
    med.lote := '11113';
    med.numero_serial := '8623344444223468699';  // Cambiar este valor si recibe error que ya fue informado el medicamento.
    med.id_obra_social := '600309';
    med.id_evento := 156;
    med.cuit_origen := '20939802593';
    med.cuit_destino := '20929007862';
    med.apellido := 'Abel';
    med.nombres := 'Miranda';
    med.tipo_documento := 96;
    med.n_documento := '93980259';
    med.sexo := 'M';
    med.direccion := 'Blanco Encalada';
    med.numero := '1234';
    med.piso := '';
    med.dpto := '';
    med.localidad := 'Capital Federal';
    med.provincia := 'Buenos Aires';
    med.n_postal := '1428';
    med.fecha_nacimiento := '01/01/2000';
    med.telefono := '5555-5555';

    trazamedObj.AgregaMedicamento(med);
    If Not trazamedObj.SendMedicamentos Then
      ShowMessage(trazamedObj.Errores)
    Else
      ShowMEssage('Transaccin exitosa! Id de transaccin: ' + trazamedObj.id_transaccion);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  trazamedObj: ITrazaMed;
  med: ImedicamentosDTOdhSerie;
begin

  // Realiza el registro de una transaccin de medicamento.
  // Se enva por cada GTIN, el nmero de serie desde y nmero de serie hasta.
  // Es utilizado para nmeros de serie lineales numricos consecutivos.

  trazamedObj := CoTrazaMed.Create;
  med := ComedicamentosDTOdhSerie.Create;

  trazamedObj.modo_produccion := False;
  trazaMedObj.LogTransaction('Request.xml', 'Response.xml'); //Deja un log de cada transaccion en los archivos.

  trazamedObj.usuario := 'pruebasws';
  trazamedObj.password := 'pruebasws';

  med.f_evento := '24/04/2012';
  med.h_evento := '04:24';
  med.gln_origen := '9999999999918';
  med.gln_destino := 'glnws';
  med.n_remito := 'R000100000001';
  med.n_factura := 'F000100000001';
  med.vencimiento := '30/12/2011';
  med.gtin := 'GTIN2';
  med.lote := '11113';
  med.desde_numero_serial := '862334444422349';  // Cambiar este valor si recibe error que ya fue informado el medicamento.
  med.hasta_numero_serial := '862334444422350';  // Cambiar este valor si recibe error que ya fue informado el medicamento.
  med.id_obra_social := 600309;
  med.id_evento := 156;
  med.cuit_origen := '20939802593';
  med.cuit_destino := '20929007862';
  med.apellido := 'Abel';
  med.nombres := 'Miranda';
  med.tipo_documento := '96';
  med.n_documento := '93980259';
  med.sexo := 'M';
  med.direccion := 'Blanco Encalada';
  med.numero := '1234';
  med.piso := '';
  med.dpto := '';
  med.localidad := 'Capital Federal';
  med.provincia := 'Buenos Aires';
  med.n_postal := '1428';
  med.fecha_nacimiento := '01/01/2000';
  med.telefono := '5555-5555';

  trazamedObj.AgregaMedicamentoDHSerie(med);
  If Not trazamedObj.sendMedicamentosDHSerie Then
    ShowMessage(trazamedObj.Errores)
  Else
    ShowMessage(trazamedObj.id_transaccion);
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  trazamedObj: ITrazaMed;
begin
    trazamedObj := CoTrazaMed.Create;

    trazamedObj.modo_produccion := False;
    trazamedObj.LogTransaction('Request.xml', 'Response.xml'); //Deja un log de cada transaccion en los archivos.

    trazamedObj.usuario := 'pruebasws';
    trazamedObj.password := 'pruebasws';

    If Not trazamedObj.SendCancelaTransacc('1234') Then
      ShowMessage(trazamedObj.Errores)
    Else
      ShowMessage('Transaccin exitosa! Id de transaccin: ' + trazamedObj.id_transaccion);

end;

procedure TForm1.Button4Click(Sender: TObject);
var
  trazamedObj: ITrazaMed;
begin
    trazamedObj := CoTrazaMed.Create;

    trazamedObj.modo_produccion := False;
    trazamedObj.LogTransaction('Request.xml', 'Response.xml'); //Deja un log de cada transaccion en los archivos.

    trazamedObj.usuario := 'pruebasws';
    trazamedObj.password := 'pruebasws';

    If Not trazamedObj.SendAlertaTransacc('1234') Then
      ShowMessage(trazamedObj.Errores)
    Else
      ShowMessage('Transaccin exitosa! Id de transaccin: ' + trazamedObj.id_transaccion);

end;

procedure TForm1.Button5Click(Sender: TObject);
var
  trazamedObj: ITrazamed;
  transacciones: ITransaccionPlainWS;
  i: Integer;
  msg: String;
begin
    trazamedObj := CoTrazaMed.Create;
    transacciones := CoTransaccionPlainWS.Create;

    trazamedObj.modo_produccion := False;
    trazamedObj.LogTransaction('Request.xml', 'Response.xml'); // Deja un log de cada transaccion en los archivos.

    trazamedObj.usuario := 'pruebasws';
    trazamedObj.password := 'Clave1234';

    If Not trazamedObj.GetTransaccionesNoConfirmadas(0, '', '', '9999999999918', '', 0, '', '', '', '', '', '', '', '', 0, '', '', 0, 20, transacciones) Then
      ShowMessage(trazamedObj.Errores)
    Else begin
      If (transacciones.Count = 0) Then
        ShowMessage ('No hay transacciones pendientes de confirmacin')
      Else begin
        msg := '';
        For i := 1 To transacciones.Count do begin
           msg := msg + FloatToStr(transacciones.id_transaccion) + #13;
           transacciones.Index := transacciones.Index + 1
        end;
        ShowMessage('Hay ' + IntToStr(transacciones.Count) + ' transacciones pendientes de confirmacin pagina 1 de ' + IntToStr(transacciones.cantPaginas) + Chr(13) + Chr(13) + msg);
      End
    End
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  trazamedObj: ITrazaMed;
  stock: IConsultaStockWSResult;
begin
  trazamedObj := CoTrazaMed.Create;
  stock := CoConsultaStockWSResult.Create;

  trazamedObj.modo_produccion := false;
  trazamedObj.LogTransaction('Request.xml', 'Response.xml'); // Deja un log de cada transaccion en los archivos.

  trazamedObj.usuario := 'pruebasws';
  trazamedObj.password := 'Clave1234';

  if not trazamedObj.getConsultaStock('', '', '', 0, '', '', '', 1, 10, stock) Then
    ShowMessage(trazamedObj.Errores)
  else
  begin
    if (stock.Count = 0) then
      ShowMessage('No hay resultados en la consulta')
    else
      // Propediades de stock en
      // http://bitingenieria.com.ar/doc/trazamedlib/TrazaMedLib_TLB/IConsultaStockWSResult.html
      ShowMessage('Hay ' + IntToStr(stock.Count) + ' registros de stock pagina 1 de ' + IntToStr(stock.cantPaginas));

      stock.index := 0 // Varial el index de 0 a Count - 1 para cambiar el item de la lista.

  end
end;

end.
